function dydt=K2SURF_limonene_F(t,y)
global sigma a0 W kd ksr ratio_down

%----------Initialize matrix sizes------

dydt=zeros(3,1);

Thetas=sigma(1)*y(1)+sigma(1)*y(3); % Surface coverage (no units)

%Transport fluxes
Jcoll=W(1)/4.*y(2); % Collision flux of limonene with the SiO2 surface (cm-2 s-1)
Jads(1)=a0.*(1-Thetas).*Jcoll.*ratio_down; % Adsorption flux of limonene with the SiO2 surface resulting in the C* down limonene configuration (cm-2 s-1)
Jads(2)=a0.*(1-Thetas).*Jcoll.*(1-ratio_down); % Adsorption flux of limonene with the SiO2 surface resulting in the C* up limonene configuration (cm-2 s-1)
Jdes(1)=kd(1).*y(1); % Desorption flux of the C* down limonene configuration (cm-2 s-1)
Jdes(2)=kd(2).*y(3); % Desorption flux of the C* up limonene configuration (cm-2 s-1)

%Conversion rates between the C* down and C* up limonene configurations
Ps(1)=-ksr(1)*y(1)+ksr(2)*y(3); %C* down (molec. cm-2 s-1)
Ps(3)=ksr(1)*y(1)-ksr(2)*y(3); %C* up (molec. cm-2 s-1)

%-------------Differential equations---------
% Adsorbed C* down limonene configuration
dydt(1)=Jads(1)-Jdes(1)+Ps(1); % (molec cm-2 s-1)

% Gas-phase limonene
dydt(2)=0;% Gas-phase concentration remains constant over the 1 second time period of the simulations (molec cm-3 s-1)

% Adsorbed C* up limonene configuration
dydt(3)=Jads(2)-Jdes(2)+Ps(3); % (molec cm-2 s-1)   

end